/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_marker.cpp
 *
 *  Base class for marking a MarkSet using a MotifIncidenceSet.
 */


#include "common.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_set.hpp"
#include "mark_set.hpp"
#include "motif_incidence_marker.hpp"


void
MotifIncidenceMarker::markIncidence( const MotifIncidenceSet& incidence, MarkSet& marks )
{
//	if(marks.motif == "GCTGTC")
//		cout << "motif = GCTGTC, incidence = " << incidence << endl;
//	if(marks.motif == "GACAGC")
//		cout << "motif = GACAGC, incidence = " << incidence << endl;
//	if(marks.motif == "GCTGTC|GACAGC")
//		cout << "motif = GCTGTC|GACAGC, incidence = " << incidence << endl;	
	
	marks.unmark();
	for( MotifIncidenceSet::const_iterator i = incidence.begin(); i != incidence.end(); ++i )
		marks[ i->getSeqNum() ] = true;
}
