/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_incidence_set.cpp
 *
 *  Class for representing the incidence of a motif.
 */



#include <vector>
#include <iostream>

#include "common.hpp"
#include "motif_instance.hpp"

#include "motif_incidence_set.hpp"


void
MotifIncidenceSet::clear()
{
	incidence.clear();
}


unsigned int
MotifIncidenceSet::size() const
{
	return incidence.size();
}


void
MotifIncidenceSet::addInstance( const MotifInstance& i )
{
	incidence.push_back( i );
}


void
MotifIncidenceSet::addInstances( const MotifIncidenceSet& s )
{
//	unsigned int n = incidence.size();
//	incidence.resize( n + s.size() );
//	copy( s.begin(), s.end(), incidence.begin() + n );
	copy( s.begin(), s.end(), back_inserter( incidence ) );
}


void
MotifIncidenceSet::addInstances( const MotifIncidenceSet* s )
{
	if( s != 0 )
		addInstances( *s );
}

void
MotifIncidenceSet::makeUniqueIncidence()
{
	sort( incidence.begin(), incidence.end() );
	IncidenceVector::iterator new_end = unique( incidence.begin(), incidence.end() );
	incidence.resize( new_end - incidence.begin() );
}


MotifIncidenceSet::iterator
MotifIncidenceSet::begin()
{
	return incidence.begin();
}


MotifIncidenceSet::iterator
MotifIncidenceSet::end()
{
	return incidence.end();
}


MotifIncidenceSet::const_iterator
MotifIncidenceSet::begin() const
{
	return incidence.begin();
}


MotifIncidenceSet::const_iterator
MotifIncidenceSet::end() const
{
	return incidence.end();
}



ostream& operator<<( ostream& os, const MotifIncidenceSet& s )
{
	os << '{';
	if( s.size() > 0 ) {
		MotifIncidenceSet::const_iterator i = s.begin();
		os << *i++;
		for( ; i != s.end(); ++i )
			os << ", " << *i;
	}
	os << '}';
	
	return os;
}
