/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  motif_instance.hpp
 *
 *  Class for representing an instance of a motif in a sequence
 */


#ifndef MOTIF_INSTANCE_H
#define MOTIF_INSTANCE_H


#include <vector>
#include <iostream>

#include "common.hpp"

class MotifInstance {
public:
	typedef		unsigned int		SequenceNumber;
	typedef		unsigned int		SequencePosition;

public:
	MotifInstance()
		: seqNum( 0 ), seqPos( 0 ) {}
	MotifInstance( SequenceNumber n, SequencePosition p )
		: seqNum( n ), seqPos( p ) {}
	
	SequenceNumber		getSeqNum() const;
	SequencePosition	getSeqPos() const;
	
	void operator=( const MotifInstance& rhs );
	bool operator<( const MotifInstance& rhs ) const;
	bool operator==( const MotifInstance& rhs ) const;
	
private:
	SequenceNumber		seqNum;
	SequencePosition	seqPos;
};


ostream& operator<<( ostream& os, const MotifInstance& i );


#endif // MOTIF_INSTANCE_H
