/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  named_motif_incidence_map.cpp
 *
 *  Specialization of MotifIncidenceMap for explicitly named motifs.
 */


#include "common.hpp"
#include "motif_incidence_map.hpp"
#include "named_motif_incidence_map.hpp"


void
NamedMotifIncidenceMap::getMotifName( MotifNumber m, string& motifName ) const
{
	MotifNameMapType::const_iterator i = motifNames.find( m );
	if( i == motifNames.end() )
		throw( MotifADEException( "NamedMotifIncidenceMap::getMotifName: MotifNumber given does not have an entry in this MotifIncidenceMap." ) );
	motifName = i->second;
}


void
NamedMotifIncidenceMap::setMotifName( MotifNumber m, const string& motifName )
{
	motifNames[ m ] = motifName;
	touchMotif( m );
}
