/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  named_motif_incidence_map.hpp
 *
 *  Specialization of MotifIncidenceMap for explicitly named motifs.
 */


#ifndef NAMED_MOTIF_INCIDENCE_MAP_H
#define NAMED_MOTIF_INCIDENCE_MAP_H


#include <string>
#include <vector>

#include "common.hpp"
#include "motif_incidence_map.hpp"


class NamedMotifIncidenceMap : public MotifIncidenceMap {
public:
#ifdef MOTIFADE_USE_HASH_MAP
	typedef hash_map< MotifNumber, string >	MotifNameMapType;
#else
	typedef map< MotifNumber, string >		MotifNameMapType;
#endif

public:
	NamedMotifIncidenceMap() {}
	virtual ~NamedMotifIncidenceMap() {}
	
	virtual void getMotifName( MotifNumber m, string& motifName ) const;
	
	virtual void setMotifName( MotifNumber m, const string& motifName );
	
private:
	MotifNameMapType motifNames;
};


#endif // NAMED_MOTIF_INCIDENCE_MAP_H
