/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  neighborhood_kmer_incidence_computer.hpp
 *
 *  Class that computes the incidence of (k,r)-motifs
 */


#ifndef NEIGHBORHOOD_KMER_INCIDENCE_COMPUTER_H
#define NEIGHBORHOOD_KMER_INCIDENCE_COMPUTER_H


#include <string>
#include <vector>

#include "common.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_set.hpp"
#include "motif_incidence_map.hpp"
#include "kmer_incidence_map.hpp"
#include "motif_incidence_computer.hpp"


class NeighborhoodKmerIncidenceComputer : public MotifIncidenceComputer {
public:
	
	NeighborhoodKmerIncidenceComputer( unsigned int r ): radius( r ) /*, positions( r )*/ {}
	virtual ~NeighborhoodKmerIncidenceComputer() {}
	
	virtual void computeIncidence( MotifIncidenceMap::MotifNumber m, const MotifIncidenceMap* incidenceMap, MotifIncidenceSet& incidence );

protected:

	void computeNeighborhoodIncidence( KmerEncoder::KmerValue kmer, const KmerIncidenceMap& incidenceMap, unsigned int r, MotifIncidenceSet& incidence );
	void computeNeighborIncidence( KmerEncoder::KmerValue kmer, const KmerIncidenceMap& incidenceMap, const uvector& positions, MotifIncidenceSet& incidence );


protected:
	
	MotifIncidenceSet   incidence;
	const unsigned int  radius;
	
	// TODO: hoist positions and successors allocations
//	uvector				positions;
	
};


#endif // NEIGHBORHOOD_KMER_INCIDENCE_COMPUTER_H
