/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  orthology_annotator.cpp
 *
 *  Class to associate orthologs with promoters using an OrthologyMap
 */


#include <set>

#include "common.hpp"

#include "sequence.hpp"
#include "sequence_set.hpp"
#include "promoter.hpp"
#include "promoter_set.hpp"

#include "orthology_map.hpp"
#include "operation_stats.hpp"
#include "orthology_annotator.hpp"


void
OrthologyAnnotator::annotate( OrthologyMap& oMap, SequenceSet& orthologs, OrthologyAnnotator::Stats& stats )
{
	stats.clear();
	
	stats.num_mappings_in_map = oMap.size();
	stats.promoter_set_size = promoters.size();
	stats.ortholog_set_size = orthologs.size();
	stats.removePromotersWithoutOrthologs = removeNonAnnotated;
	
	for( PromoterSet::iterator i = promoters.begin(); i != promoters.end(); ++i ) {
		Promoter* p = *i;
		OrthologyMap::iterator o = oMap.find( p->getID() );
		if( o != oMap.end() ) {
			++stats.num_promoters_with_orthologs_in_map;
			const Sequence::IDType& oID = o->second;
			Sequence* s = orthologs.get( oID );
			if( s != 0 ) {
				++stats.num_promoters_with_orthologs;
				p->addOrtholog( s );
				orthologs.remove( oID, false );
			} else {
				stats.nonAnnotatedIDs.insert( p->getID() );
			}
		} else {
			stats.nonAnnotatedIDs.insert( p->getID() );
		}
	}
	
	if( removeNonAnnotated ) {
		for( IDSet::iterator i = stats.nonAnnotatedIDs.begin(); i != stats.nonAnnotatedIDs.end(); ++i )
			promoters.remove( *i );
	}
	
	stats.num_promoters_retained = promoters.size();
}
