/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  orthology_map_reader.cpp
 *
 *  Simple class for reading a mapping between IDs of orthologous genes from a stream.
 */


#include <map>
#include <set>

#include "common.hpp"
#include "buffered_reader.hpp"
#include "sequence.hpp"

#include "orthology_map.hpp"
#include "column_map_reader.hpp"
#include "bijective_map_filter.hpp"
#include "operation_stats.hpp"
#include "orthology_map_reader.hpp"

	
void
OrthologyMapReader::load( OrthologyMap& oMap, OrthologyMapReader::Stats& stats )
{
	stats.clear();
	
	oMap.clear();
	
	MMapType mMap;
	
	ColumnMapReader< MMapType > mReader( is, keyCol, valueCol, delimiter );
	ColumnMapReader< MMapType >::Stats mReaderStats;
	mReader.load( mMap, mReaderStats );
	
	BijectiveMapFilter< MMapType, OrthologyMap > mFilter;
	BijectiveMapFilter< MMapType, OrthologyMap >::Stats mFilterStats;
	mFilter.filter( mMap, oMap, mFilterStats );
	
	
	stats.num_mappings_loaded = mReaderStats.num_mappings_loaded;
	stats.num_missing_keys = mReaderStats.num_missing_keys;
	stats.num_missing_values = mReaderStats.num_missing_values;
	stats.num_unique_keys = mFilterStats.num_unique_keys;
	stats.num_unique_values = mFilterStats.num_unique_values;
	stats.num_repeated_keys = mFilterStats.num_repeated_keys;
	stats.num_repeated_values = mFilterStats.num_repeated_values;
	stats.num_key_repeats = mFilterStats.num_key_repeats;
	stats.num_value_repeats = mFilterStats.num_value_repeats;
	stats.num_mappings_retained = mFilterStats.num_mappings_retained;
}
