/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  precomputed_motif_incidence_collector.cpp
 *
 *  Class for collecting the incidence of a set motifs that has been previously
 *  computed and stored using the -i option.
 */

#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "gene_id_set.hpp"
#include "gene_id_set_marker.hpp"
#include "gene_id_set_collection.hpp"
#include "motif_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"
#include "named_motif_incidence_collector.hpp"
#include "precomputed_motif_incidence_collector.hpp"


MotifIncidenceMap*
PrecomputedMotifIncidenceCollector::collectIncidence( const SequenceVector& seqs )
{
	NamedMotifIncidenceMap* m = new NamedMotifIncidenceMap;
	
	uvector indexScratch;
	GeneIDSetMarker marker( seqs );
	
	unsigned int motifNum = 0;
	for( GeneIDSetCollection::const_iterator iter = geneSets.begin(); iter != geneSets.end(); ++iter ) {
		m->setMotifName( motifNum, iter->first );
		marker.markGeneSet( iter->second, indexScratch );
		for( unsigned int i = 0; i < indexScratch.size(); ++i )
			addInstance( *m, motifNum, MotifInstance( indexScratch[ i ], 0 ) ); // adding a MotifInstance with (bogus) position always 0
		++motifNum;
	}
	
	return m;
}


// UNSUPPORTED METHOD!!!
void
PrecomputedMotifIncidenceCollector::collectIncidence( MotifIncidenceMap::MotifNumber motifNum, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m )
{
	throw( MotifADEException( "error: PrecomputedMotifIncidenceCollector::collectIncidence is an unsupported method!" ) );
}
