/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  precomputed_motif_incidence_collector.hpp
 *
 *  Class for collecting the incidence of a set motifs that has been previously
 *  computed and stored using the -i option.
 */


#ifndef PRECOMPUTED_MOTIF_INCIDENCE_COLLECTOR_H
#define PRECOMPUTED_MOTIF_INCIDENCE_COLLECTOR_H


#include <string>
#include <vector>

#include "common.hpp"
#include "sequence.hpp"
#include "gene_id_set.hpp"
#include "gene_id_set_collection.hpp"
#include "motif_incidence_map.hpp"
#include "motif_instance.hpp"
#include "motif_incidence_collector.hpp"
#include "named_motif_incidence_collector.hpp"


class PrecomputedMotifIncidenceCollector : public NamedMotifIncidenceCollector {
public:
	
	PrecomputedMotifIncidenceCollector( GeneIDSetCollection& gene_sets ) : geneSets( gene_sets ) {}
	virtual ~PrecomputedMotifIncidenceCollector() {}
	
	virtual MotifIncidenceMap* collectIncidence( const SequenceVector& seqs );
	
	virtual void collectIncidence( MotifIncidenceMap::MotifNumber motifNum, unsigned int seqNum, const SequenceVector& seqs, MotifIncidenceMap* m ); // UNSUPPORTED METHOD
		
protected:
	
	const GeneIDSetCollection& geneSets;
};


#endif // PRECOMPUTED_MOTIF_INCIDENCE_COLLECTOR_H
