/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  promoter.cpp
 *
 *  Simple class to hold a promoter (i.e. sequence with ortholog sequences).
 */


#include <iostream>

#include "common.hpp"
#include "sequence.hpp"
#include "expression_vector.hpp"
#include "promoter.hpp"


ostream& operator<<( ostream& os, const Promoter& p )
{
	os << p.getHeader() << " -- Expression: " << p.getExpression() << endl << p.getData() << endl;
	for( SequenceVector::const_iterator i = p.getOrthologs().begin(); i != p.getOrthologs().end(); ++i )
		os << '\t' << ( *i )->getHeader() << endl << '\t' << ( *i )->getData() << endl;
	return os;
}
