/* Copyright (C) 2003-2008 Dan Arlow
 * 
 * This file is part of motifADE.
 * 
 * motifADE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * motifADE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with motifADE.  If not, see <http://www.gnu.org/licenses/>.
 */

/* 
 *  sequence_with_expression.hpp
 *
 *  Interface to sequence data abstractons.
 *
 *  Copyright (c) 2003 Dan Arlow. All rights reserved. DO NOT DISTRIBUTE.
 *
 *  CREATED  06/25/03
 *  MODIFIED 06/09/04
 *
 */


#ifndef SEQUENCE_WITH_EXPRESSION_H
#define SEQUENCE_WITH_EXPRESSION_H


#include <iostream>
#include <functional>
#include <string>
#include <vector>
#include <iterator>


#include "common.hpp"
#include "sequence.hpp"


using namespace std;


// data structure to glue together expression data with a sequence object
class SequenceWithExpression : public Sequence {
public:
    SequenceWithExpression() { }
    SequenceWithExpression( const SequenceWithExpression& s );
    SequenceWithExpression( const HeaderType& init_header, const IDType& init_id, const DataType& init_data );
    SequenceWithExpression( HeaderType* init_header, DataType* init_data, bool parse_expression = true );
    
    ~SequenceWithExpression() { }
	
    void				parseExpression();
	
    // accessor functions
	unsigned int		getExpressionDimension()					const { return expression.size(); }
    double				getExpression( unsigned int i )				const { return expression.at( i ); }
    const dvector&		getExpression()								const { return expression; }
    
    // mutator functions
    void				setExpression( const HeaderType& e, dvector::difference_type offset = 0 ); // too big to define here
    void				setExpression( unsigned int i, double e )	{ expression.at( i ) = e; }
    void				setExpression( const dvector& e )			{ expression = e; }
	void				addExpression( double e )					{ expression.push_back( e ); }
    void				addExpression( const dvector& e )			{ copy( e.begin(), e.end(), back_inserter( expression ) ); }
	void				clearExpression()							{ expression.clear(); }
	
protected:
    dvector				expression;
};


typedef vector< SequenceWithExpression* >   SequenceWithExpressionVector;


#endif // SEQUENCE_WITH_EXPRESSION_H
